
//
// To jest przykadowy kod z podrozdziau 11.7 Stosowanie niestandardowych separatorw ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <algorithm>
#include <iostream>
#include <string>
#include <sstream>
#include <vector>

using namespace std;

//------------------------------------------------------------------------------

class Punct_stream { // Podobna do istream, ale umoliwia rozszerzanie
                     // zestawu biaych znakw.
public:
    Punct_stream(istream& is)
        : source(is), sensitive(true) { }

    void whitespace(const string& s)       // s jest zbiorem biaych znakw.
    { white = s; }    
    void add_white(char c) { white += c; } // Dodaje znak do zbioru biaych znakw.
    bool is_whitespace(char c);            // Czy c naley do zbioru biaych znakw?

    void case_sensitive(bool b) { sensitive = b; }
    bool is_case_sensitive() { return sensitive; }

    Punct_stream& operator>>(string& s);
    operator bool();
private:
    istream& source;       // rdo znakw
    istringstream buffer;  // Formatowanie wykonuje bufor.
    string white;          // Znaki uznawane za biae.
    bool sensitive;        // Czy strumie rozpoznaje wielko liter?
};

//------------------------------------------------------------------------------

Punct_stream& Punct_stream::operator>>(string& s)
{
    while (!(buffer>>s)) {    // Prba wczytania danych z bufora.
        if (buffer.bad() || !source.good()) return *this;
        buffer.clear();

        string line;
        getline(source,line); // Pobranie wiersza danych ze rda (source).

        // Zastpowanie znakw zgodnie z potrzeb:
        for (int i =0; i<line.size(); ++i)
            if (is_whitespace(line[i]))
                line[i]= ' ';
            else if (!sensitive)
                line[i] = tolower(line[i]);

        buffer.str(line);     // Wstawianie acucha do strumienia.
    }
    return *this;
}

//------------------------------------------------------------------------------

bool Punct_stream::is_whitespace(char c)
{
    for (int i = 0; i<white.size(); ++i) if (c==white[i]) return true;
    return false;
}

//------------------------------------------------------------------------------

Punct_stream::operator bool()
{
    return !(source.fail() || source.bad()) && source.good();
}

//------------------------------------------------------------------------------

int main()
// Przyjmuje tekst. Tworzy posortowan list wszystkich sw w tym tekcie,
// ignoruje interpunkcj i rnice wielkoci liter oraz
// usuwa duplikaty z danych wyjciowych.

{
    Punct_stream ps(cin);
    ps.whitespace(";:,.?!()\"{}<>/&$@#%^*|~"); // Zauwa, e \" oznacza " w acuchu.
    ps.case_sensitive(false);

    cout << "Wpisz sowa.\n";
    vector<string> vs;
    string word;
    while (ps>>word) vs.push_back(word);    // Wczytuje sowa.

    sort(vs.begin(),vs.end());              // Sortuje w porzdku leksykograficznym.
    for (int i=0; i<vs.size(); ++i)         // Zapisuje sownik.
        if (i==0 || vs[i]!=vs[i-1]) cout << vs[i] << endl;
}

//------------------------------------------------------------------------------
